﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Threading;
using System.Runtime.InteropServices;
//using System.IO;
using System.Runtime.Serialization;

namespace MutexFun
{
	[StructLayout(LayoutKind.Sequential)]
	[Serializable()]
	public struct Contact
	{
		public string _name;
		public int _age;
	}

	class Program
	{
		static void Main(string[] args)
		{
			if (args.Length == 0)
			{
                // utworzenie początkowego menedżera wspólnej pamięci
                using(SharedMemoryManager<Contact> sm =
	                new SharedMemoryManager<Contact>("Contacts",8092))
                {
	                // proces wysyłający

	                // uruchomienie drugiego procesu
	                string processName = Process.GetCurrentProcess().MainModule.FileName;
	                int index = processName.IndexOf("vshost");
	                if (index != -1)
	                {
		                string first = processName.Substring(0, index);
		                int numChars = processName.Length - (index + 7);
		                string second = processName.Substring(index + 7, numChars);

		                processName = first + second;
	                }
	                Process receiver = Process.Start(
		                new ProcessStartInfo(
			                processName,
			                "Receiver"));

                    // pięć sekund na podpięcie się
	                Thread.Sleep(5000);

	                // utworzenie kontaktu
	                Contact man;
	                man._age = 28;
	                man._name = "Daniel Kaczmarek";

	                // wysłanie kontaktu do innego procesu za pośrednictwem wspólnej pamięci
	                sm.SendObject(man);
                }
			}
			else
			{
				// proces odbiorcy

                // utworzenie początkowego menedżera wspólnej pamięci
                using(SharedMemoryManager<Contact> sm =
	                new SharedMemoryManager<Contact>("Contacts",8092))
                {

	                // odebranie wysłanego kontaktu
	                Contact c = (Contact)sm.ReceiveObject();

	                // wypisanie kontaktu (lubz apisanie w bazie danych...)
	                Console.WriteLine("Pan {0} ma {1} lat.",
						                c._name, c._age);

                    // wyświetlanie przez pięć sekund
                    Thread.Sleep(5000);
                }
			}

			// po odkomentowaniu widoczne będzie okno konsoli...
			Console.ReadLine();
		}
	}
}
